<?php
function lacero_cpt_course() {

	$labels = array(
		'name' =>  __('Courses', "lacero" ),
		'singular_name' => __('Courses', "lacero" ),			
		'add_new' => __('Add New', "lacero" ),			
		'add_new_item' => __('Add New Courses', "lacero" ),		
		'edit_item' => __('Edit Courses', "lacero" ),			
		'new_item' => __('New Courses', "lacero" ),			
		'all_items' => __('All Courses', "lacero" ),
		'view_item' => __('View Courses', "lacero" ),			
		'search_items' => __('Search Courses', "lacero" ),
		'not_found' =>  __('No Courses found', "lacero" ),
		'not_found_in_trash' => __('No Courses found in Trash', "lacero" ),
		'parent_item_colon' => '',
		'menu_name' => __('Courses', "lacero" )
	);
	
	$rewrite = array(
		'slug'                  => 'course-item',
		'with_front'            => true,
		'pages'                 => true,
		'feeds'                 => true,
	);
	
	$args = array(					
			'label'                 => __( 'Courses', "lacero" ),
			'description'           => __( 'Courses', "lacero" ),
			'labels'                => $labels,
			'supports'              => array( 'title', 'editor', 'thumbnail', ),
			'hierarchical'          => false,
			'public'                => true,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'rewrite'  => $rewrite,
			'menu_position' => 101,
			'menu_icon' => 'dashicons-clipboard',
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'can_export'            => true,
			'has_archive'           => true,
			'exclude_from_search'   => false,
			'publicly_queryable'    => true,
			'capability_type'       => 'post',
	);

	register_post_type( 'lacero_courses', $args );
}
add_action( 'init', 'lacero_cpt_course', 0 );

// Register Custom Taxonomy
function lacero_tax_course() {

	$labels = array(
		'name'                       => _x( 'Courses Categories', 'Taxonomy General Name', "lacero" ),
		'singular_name'              => _x( 'Courses Categories', 'Taxonomy Singular Name', "lacero" ),
		'menu_name'                  => __( 'Category', "lacero" ),
		'all_items'                  => __( 'All Items', "lacero" ),
		'parent_item'                => __( 'Parent Item', "lacero" ),
		'parent_item_colon'          => __( 'Parent Item:', "lacero" ),
		'new_item_name'              => __( 'New Item Name', "lacero" ),
		'add_new_item'               => __( 'Add New Item', "lacero" ),
		'edit_item'                  => __( 'Edit Item', "lacero" ),
		'update_item'                => __( 'Update Item', "lacero" ),
		'view_item'                  => __( 'View Item', "lacero" ),
		'separate_items_with_commas' => __( 'Separate items with commas', "lacero" ),
		'add_or_remove_items'        => __( 'Add or remove items', "lacero" ),
		'choose_from_most_used'      => __( 'Choose from the most used', "lacero" ),
		'popular_items'              => __( 'Popular Items', "lacero" ),
		'search_items'               => __( 'Search Items', "lacero" ),
		'not_found'                  => __( 'Not Found', "lacero" ),
		'items_list'                 => __( 'Items list', "lacero" ),
		'items_list_navigation'      => __( 'Items list navigation', "lacero" ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
	);
	register_taxonomy( 'lacero_course_tax', array( 'lacero_courses' ), $args );

}
add_action( 'init', 'lacero_tax_course', 0 );
?>