<?php
/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Metaboxes
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */

/**
 * Gets a number of terms and displays them as options
 * @param  string       $taxonomy Taxonomy terms to retrieve. Default is category.
 * @param  string|array $args     Optional. get_terms optional arguments
 * @return array                  An array of options that matches the CMB2 options array
 */

add_action( 'cmb2_init', 'lacero_register_metabox' );
/**
 * Hook in and add a demo metabox. Can only happen on the 'cmb2_init' hook.
 */
function lacero_register_metabox() {

	// Start with an underscore to hide fields from custom fields list
	$prefix = 'lacero_cf_';

	/* ## Page/Post Options ---------------------- */

	/* - Page Description */
	$cmb_page = new_cmb2_box( array(
		'id'            => $prefix . 'metabox_page',
		'title'         => esc_html( 'Page Options', "lacero" ),
		'object_types'  => array( 'page', 'post', 'lacero_events' ), // Post type
		'context'       => 'normal',
		'priority'      => 'high',
		'show_names'    => true, // Show field names on the left
	) );

	$cmb_page->add_field( array(
		'name'             => 'Content Area Padding ?',
		'desc'             => 'If your content section need to have just after header area without space, please select an option Off',
		'id'               => $prefix . 'content_padding',
		'type'             => 'select',
		'default'          => 'on',
		'options'          => array(
			'on' => esc_html( 'On', "lacero" ),
			'off'   => esc_html( 'Off', "lacero" ),
		),
	) );
	
	$cmb_page->add_field( array(
		'name'             => 'Newsletter',
		'desc'             => 'Select an option',
		'id'               => $prefix . 'page_newslatter',
		'type'             => 'select',
		'default'          => 'on',
		'options'          => array(
			'on' => esc_html( 'On', "lacero" ),
			'off'   => esc_html( 'Off', "lacero" ),
		),
	) );
	
	
	$cmb_page->add_field( array(
		'name'             => 'Page Layout',
		'desc'             => 'Select an option',
		'id'               => $prefix . 'page_layout',
		'type'             => 'select',
		'default'          => 'fixed',
		'options'          => array(
			'fixed' => esc_html( 'Fixed', "lacero" ),
			'fluid'   => esc_html( 'Fluid', "lacero" ),
		),
	) );

	$cmb_page->add_field( array(
		'name'             => 'Sidebar Position',
		'desc'             => 'Select an option',
		'id'               => $prefix . 'sidebar_layout',
		'type'             => 'select',
		'default'          => 'primary_sidebar',
		'options'          => array(
			'right_sidebar'   => esc_html( 'Right', "lacero" ),
			'left_sidebar' => esc_html( 'Left', "lacero" ),
			'no_sidebar'   => esc_html( 'None', "lacero" ),
		),
	) );

	$cmb_page->add_field( array(
		'name'             => 'Widget Area',
		'desc'             => 'Select an option',
		'id'               => $prefix . 'widget_area',
		'type'             => 'select',
		'default'          => 'sidebar-1',
		'options'          => array(
			'sidebar-1' => esc_html( 'Primary Sidebar', "lacero" ),
			'sidebar-2'   => esc_html( 'Secondary Sidebar', "lacero" ),
		),
	) );

	$cmb_page->add_field( array(
		'name'             => 'Page Header',
		'desc'             => 'Select an option',
		'id'               => $prefix . 'page_title',
		'type'             => 'select',
		'default'          => 'enable',
		'options'          => array(
			'enable' => esc_html( 'Enable', "lacero" ),
			'disable'   => esc_html( 'Disable', "lacero" ),
		),
	) );

	$cmb_page->add_field( array(
		'name' => esc_html( 'Header Image', "lacero" ),
		'desc' => esc_html( 'Upload an image or enter a URL.', "lacero" ),
		'id'   => $prefix . 'page_header_img',
		'type' => 'file',
	) );
	
	$cmb_page->add_field( array(
		'name' => esc_html( 'Page Header Tilte', "lacero" ),
		'id'   => $prefix . 'page_small_title',
		'type' => 'text',
	) );
	
	$cmb_page->add_field( array(
		'name' => esc_html( 'Page Header Short Description', "lacero" ),
		'id'   => $prefix . 'page_small_desc',
		'type' => 'textarea',
	) );

	$prefix_cmb = "cmb_";

	/* ## Post Options ---------------------- */
	require_once( $prefix_cmb . "post.php");
	
	/* ## Event Options ---------------------- */
	require_once( $prefix_cmb . "events.php");
	
	/* ## Courses Options ---------------------- */
	require_once( $prefix_cmb . "course.php");

}
?>