<?php
// Start with an underscore to hide fields from custom fields list
$prefix = 'lacero_cf_';

$cmb_events = new_cmb2_box( array(
	'id'            => $prefix . 'metabox_events',
	'title'         => __( 'Event Options', "lacero" ),
	'object_types'  => array( 'lacero_events' ), // Post type
	'context'       => 'normal',
	'priority'      => 'high',
	'show_names'    => true, // Show field names on the left
) );

$cmb_events->add_field( array(
	'name'         => __( 'Event Date/Time', "lacero" ),
	'id'           => $prefix . 'event_datetime',
	'desc'           => __("e.g May 14, 2016 3.00 pm", "lacero"),
	'type'         => 'text',
) );

$cmb_events->add_field( array(
	'name'         => __( 'Location', "lacero" ),
	'id'           => $prefix . 'event_location',
	'type'         => 'textarea_small',
	'desc'           => __("e.g 189 Design Street, Web Corner Melbourne - 18, Australia", "lacero"),
) );

$cmb_events->add_field( array(
	'name'         => __( 'Email', "lacero" ),
	'id'           => $prefix . 'event_email',
	'desc'           => __("e.g info@example.com", "lacero"),
	'type'         => 'text',
) );

$cmb_events->add_field( array(
	'name'         => __( 'Phone', "lacero" ),
	'id'           => $prefix . 'event_phone',
	'desc'           => __("e.g (01) 800 433 633", "lacero"),
	'type'         => 'text',
) );


$cmb_events->add_field( array(
	'name'         => __( 'Map Latitute', "lacero" ),
	'id'           => $prefix . 'map_latitude',
	'type'         => 'text',
	'desc'           => __("e.g -35.278930", "lacero"),
) );

$cmb_events->add_field( array(
	'name'         => __( 'Map Longitute', "lacero" ),
	'id'           => $prefix . 'map_longitute',
	'type'         => 'text',
	'desc'           => __("e.g 149.128125", "lacero"),
) );
$cmb_events->add_field( array(
	'name'         => __( 'Map Marker Address', "lacero" ),
	'id'           => $prefix . 'event_address',
	'type'         => 'text',
	'desc'           => __("e.g 189 Design Street, Web Corner Melbourne - 18, Australia", "lacero"),
) );
?>