<?php
	if( get_post_meta( get_the_ID(), 'lacero_cf_page_header_img', true ) != "" ) {
		$header_image = get_post_meta( get_the_ID(), 'lacero_cf_page_header_img', true );
	}
	else {
		$header_image = LACERO_IMGURI . '/page-banner.jpg';
	}

	if( get_post_meta( get_the_ID(), 'lacero_cf_page_title', true ) != "disable") :
		?>
		<div class="page-banner about-banner container-fluid no-padding" <?php if( $header_image != "" ) { ?> style="background-image: url(<?php echo esc_url( $header_image ); ?>);"<?php } ?>>
			<div class="page-banner-shape">
				<svg width="100%" height="100%">
					<clipPath id="banner-shape" clipPathUnits="objectBoundingBox">
						<polygon points="0 0, 0 1, 1 1, 0.70 0"></polygon>
					</clipPath>
				</svg>
			</div>
			
			<div class="container">
				<div class="row">
					<div class="col-md-4 col-sm-6 col-xs-7 page-banner-content">
						<h4>
							<?php
							if( get_post_meta( get_the_ID(), 'lacero_cf_page_small_title', true ) != "" ) {
									?>
									<span><?php echo esc_attr( get_post_meta( get_the_ID(), 'lacero_cf_page_small_title', true ) ); ?></span>
									<?php
								}	
							elseif( is_home() ) {
								esc_html_e( 'Blog', "lacero" );
							}
							elseif( is_404() ) {
								esc_html_e( 'Page Not Found', "lacero" );
							}
							elseif( is_search() ) {
								printf( esc_html__( 'Search Results for: %s', "lacero" ), get_search_query() );
							}
							elseif( is_archive() ) {
								the_archive_title();
							}
							else {
								the_title();
							} ?>
						</h4>

						<?php
						if( function_exists( 'bcn_display' ) ) {
							?>
							<div class="breadcrumb">
								<?php bcn_display(); ?>
							</div>
							<?php
						}?>
						<?php
						if( get_post_meta( get_the_ID(), 'lacero_cf_page_small_desc', true ) != "" ) {
							?>
							<?php echo wpautop( esc_html( get_post_meta( get_the_ID(), 'lacero_cf_page_small_desc', true ) ) ); ?>
							<?php
						}
						?>
					</div>
				</div>
			</div>
		</div>
	<?php
endif; ?>