(function($) {

	"use strict";

	/* ## Document Scroll - Window Scroll */
	$( document ).scroll(function()
	{
		var scroll	=	$(window).scrollTop();
		var height	=	$(window).height();

		/*** set sticky menu ***/
		if( scroll >= height + 100 )
		{
			$('.header-main').addClass("navbar-fixed-top animated fadeInDown").delay( 2000 ).fadeIn();
		}
		else if ( scroll <= height )
		{
			$('.header-main').removeClass("navbar-fixed-top animated fadeInDown");
		}
		else
		{
			$('.header-main').removeClass("navbar-fixed-top animated fadeInDown");
		} // set sticky menu - end		

		if ($(this).scrollTop() >= 50)
		{
			// If page is scrolled more than 50px
			$('#back-to-top').fadeIn(200);    // Fade in the arrow
		}
		else
		{
			$('#back-to-top').fadeOut(200);   // Else fade out the arrow
		}
	});
	
	/* ## Document Ready - Handler for .ready() called */
	$(document).ready(function($) {
		
		$("#slider-section .carousel-inner .item:first").addClass("active");
		
		/* Flicker Image Open New Tab */
		$('.widget_flicker .flickr_photos .flickr_badge_image a').attr('target', '_blank');

		/* - Responsive Caret */
		$('.guidance-tabpanel .nav-tabs li > a').on('click', function() {
			$('html, body').animate({ scrollTop: $(".tab-content").offset().top - 120 }, 2000 );
		});

		// Expand Panel
		$("#slideit").on("click", function()	{
			$("#slidepanel").slideDown(1000);
			$("html").animate({ scrollTop: 0 }, 1000);
		});	

		// Collapse Panel
		$("#closeit").on("click", function()	{
			$("#slidepanel").slideUp("slow");	
			$("html").animate({ scrollTop: 0 }, 1000);
		});		

		// Switch buttons from "Log In | Register" to "Close Panel" on click
		$("#toggle a").on("click" ,function () {
			$("#toggle a").toggle();
		});		

		/* - Responsive Caret */
		$('.ddl-switch').on('click', function() {

			var li = $(this).parent();
			
			if ( li.hasClass('ddl-active') || li.find('.ddl-active').length !== 0 || li.find('.dropdown-menu').is(':visible') ) {
				li.removeClass('ddl-active');
				li.children().find('.ddl-active').removeClass('ddl-active');
				li.children('.dropdown-menu').slideUp();	
			}
			else {
				li.addClass('ddl-active');
				li.children('.dropdown-menu').slideDown();
			}
		});
		
		/* - Newsletter Shape */
		$(".newsletter-shape").css("clip-path",'url("#newsletter")');
		
		/* - Banner Shape */
		$(".page-banner-shape").css("clip-path",'url("#banner-shape")');
		
		/* - Banner Section */
		/* - Dark Shape */
		var dark_shape_count = 0;
		dark_shape_count = $( "[id*='dark-']" ).length;
		for(var i=1; i<=dark_shape_count; i++)
		{
			$( "[id*='dark-"+i+"']" ).css("clip-path","url('#dark_shape-"+i+"')");
		}

		/* - Triangle Shape */
		var triangle_shape_count = 0;
		triangle_shape_count = $( "[id*='triangle-']" ).length;
		for(var i=1; i<=triangle_shape_count; i++)
		{
			$( "[id*='triangle-"+i+"']" ).css("clip-path","url('#triangle_shape-"+i+"')");
		}
		
		/* -- Popular Course */
		$(".box-toggle").on("click", function() {
			$(this).parent(".courses-box").toggleClass("active");
		});
		
		/* Intro Section */
		if($(".intro-section ").length){
			$(".intro-section ").each(function ()
			{
				var $this = $(this);
				var myVal = $(this).data("value");

				$this.appear(function()
				{		
					$(".intro-section .intro-box").addClass("animated fadeInDown");
				});
			});
		}
		
		/* Popular Courses Section */
		if($(".popular-courses").length){
			$(".popular-courses").each(function ()
			{
				var $this = $(this);
				var myVal = $(this).data("value");

				$this.appear(function()
				{		
					$(".popular-courses .courses-box").addClass("animated rollIn");
				});
			});
		}
		
		/* Our Graduate Section */
		if($(".our-graduate-section").length){
			$(".our-graduate-section").each(function ()
			{
				var $this = $(this);
				var myVal = $(this).data("value");

				$this.appear(function()
				{		
					$(".our-graduate-section .container .content-box").addClass("animated fadeInUp");
					$(".our-graduate-section .container .video-block").addClass("animated fadeInDown");
				});
			});
		}
		
		/* Admission Process Section */
		if($(".admission-process").length){
			$(".admission-process").each(function ()
			{
				var $this = $(this);
				var myVal = $(this).data("value");

				$this.appear(function()
				{		
					$(".admission-process .process-box").addClass("animated fadeInRight");
				});
			});
		}
		
		/* - Testimonials */
		if( $(".testimonial-section").length ) {
			$(".testimonial").owlCarousel({
				loop: true,				
				margin: 0,
				dots: true,
				nav:false,				
				autoplay: false,				
				autoplayHoverPause:true,
				responsive:{
					0:{
						items:1
					},
					680:{
						items:2
					},
					992:{
						items:3
					},
					1200:{
						items:3
					}
				}
			});
		}

		/* -- Video Block */
		$('.popup-youtube, .popup-vimeo, .popup-gmaps').magnificPopup({
			disableOn: 700,
			type: 'iframe',
			mainClass: 'mfp-fade',
			removalDelay: 160,
			preloader: false,
			fixedContentPos: false
		});
	});

	/* ## Window Load - Handler for .load() called */
	$(window).load(function() {

		/* - Site Loader */
		if ( !$('html').is('.ie6, .ie7, .ie8') ) {
			$("#site-loader").delay(1000).fadeOut("slow");
		}
		else {
			$("#site-loader").css('display','none');
		}
	});
	
	if( $('.social-icon-share').length ) {
		
		$('.social-icon-share ul > li > a', this).bind('click', function(e) {
			e.preventDefault();
			e.stopPropagation();

			var data_action = $(this).attr('data-action');
			var data_title = $(this).attr('data-title');
			var data_url = $(this).attr('data-url');

			if( data_action == 'facebook' ) {		
				window.open('http://www.facebook.com/share.php?u='+encodeURIComponent(data_url)+'&title='+encodeURIComponent(data_title),'sharer','toolbar=0,status=0,width=580,height=325');
			}
			else if( data_action == 'google-plus' ) {
				window.open('https://plus.google.com/share?url='+encodeURIComponent(data_url),'sharer','toolbar=0,status=0,width=580,height=325');
			}
			else if( data_action == 'twitter' ) {
				window.open('http://twitter.com/intent/tweet?status='+encodeURIComponent(data_url)+'+'+encodeURIComponent(data_title),'sharer','toolbar=0,status=0,width=580,height=325');
			}
			else if( data_action == 'dribbble' ) {
				window.open('https://dribbble.com/share?url='+encodeURIComponent(data_url),'sharer','toolbar=0,status=0,width=580,height=325');
			}
		});
	}
	
})(jQuery);