<?php
/**
* The Template for displaying all single posts
*
* @package WordPress
* @subpackage Lacero
* @since Lacero 1.0
*/
get_header(); ?>

<main id="main" class="site-main page_spacing">
	<div class="container no-padding">
		<div class="content-area blog-list col-md-8 col-sm-8 content-left">
			<?php				
			if ( have_posts() ) :

				// Start the loop.
				while ( have_posts() ) : the_post();

					// Include the page content template.
					get_template_part( 'content', get_post_format() );

					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;

				// End the loop.
				endwhile;				

				// Previous/next page navigation.				
				the_posts_pagination( array(
					'prev_text'          => wp_kses( __( '<i class="fa fa-angle-left"></i> Previous', "lacero" ), array( 'i' => array( 'class' => array() ) ) ),
					'next_text'          => wp_kses( __( 'Next<i class="fa fa-angle-right"></i>', "lacero" ), array( 'i' => array( 'class' => array() ) ) ),
					'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html( 'Page', "lacero" ) . ' </span>',
				) );
				
			// If no content, include the "No posts found" template.
			else :
				get_template_part( 'content', 'none' );

			endif;
			?>
		</div>
		<div class="widget-area col-md-4 col-sm-4 col-xs-12 sidebar-right sidebar-1">
			<?php dynamic_sidebar('sidebar-1'); ?>
		</div>
	</div>
</main>

<?php get_footer(); ?>