<?php
/**
 * Lacero Customizer functionality
 *
 * @package WordPress
 * @subpackage Lacero
 * @since Lacero 1.0
 */

/**
 * Add postMessage support for site title and description for the Customizer.
 *
 * @since Lacero 1.0
 *
 * @param WP_Customize_Manager $wp_customize Customizer object.
 */
add_action( 'customize_register', 'lacero_theme_customize_register' );

function lacero_theme_customize_register( $wp_customize ) {

	$wp_customize->add_section(
		'lacero_section_1',
		array(
			'title'       => esc_html__( 'Advanced Options', "lacero" ),
			'priority'    => 30
		)
	);

	$wp_customize->add_setting(
		'custom_css',
		array(
			'default'              => '',
			'capability'           => 'edit_theme_options',
			'sanitize_callback'    => 'wp_filter_nohtml_kses',
			'sanitize_js_callback' => 'wp_filter_nohtml_kses'
		)
	);

	$wp_customize->add_control(
		'lacero_example_css_control',
		array(
			'label'    => esc_html__( 'Custom CSS', "lacero" ),
			'section'  => 'lacero_section_1',
			'settings' => 'custom_css',
			'type'     => 'textarea'
		)
	);
}