<?php
/**
 * The Header for our theme
 *
 *
 * @package WordPress
 * @subpackage Lacero
 * @since Lacero 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>
<body data-offset="200" data-spy="scroll" data-target=".ow-navigation" <?php body_class(); ?>>

	<?php
	if( lacero_options("opt_site_logo","url") != "" ) {
		$logo = lacero_options("opt_site_logo","url");
	}
	else {
		$logo = LACERO_IMGURI . "/logo.png";
	}

	if( lacero_options("opt_logo_select") == "1" && lacero_options("opt_logo_selectsecond") != "" ) {
		$menucss = " menu-textlogo";
	}
	else {
		$menucss = " menu-imagelogo";
	}
	?>
	<div class="main-container<?php echo esc_attr( $menucss ); ?>">	
		<header class="header-main container-fluid no-padding">
			<div class="container">
				<div class="row">
					<div id="loginpanel" class="show-content">
						<div class="right" id="toggle">
							<a id="slideit" href="#slidepanel"><i class="fo-icons fa fa-lock"></i></a>
							<a id="closeit" href="#slidepanel"><i class="fo-icons fa fa-unlock"></i></a>
						</div>
					</div>
					<div class="col-md-4 logo-block">
						<?php
						if( lacero_options("opt_logo_select") == '1' && lacero_options("opt_logo_selectsecond") != "" ) {
							?>
							<a class="text-logo" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo esc_attr( lacero_options("opt_logo_selectsecond") ); ?></a>
							<?php
						}
						else {
							?>
							<a class="image-logo" href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url( $logo ); ?>" alt=""/></a>
							<?php
						}
						?>
					</div>
					<div class="col-md-2 menu-block">
						<nav class="navbar ow-navigation">
							<div class="navbar-header">
								<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
									<span class="sr-only"><?php esc_html_e('Toggle navigation',"lacero"); ?></span>
									<span class="icon-bar"></span>
									<span class="icon-bar"></span>
									<span class="icon-bar"></span>
								</button>
								<?php
								if( lacero_options("opt_logo_select") == '1' && lacero_options("opt_logo_selectsecond") != "" ) {
									?>
									<a class="text-logo" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo esc_attr( lacero_options("opt_logo_selectsecond") ); ?></a>
									<?php
								}
								else {
									?>
									<a class="image-logo" href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url( $logo ); ?>" alt=""/></a>
									<?php
								}
								?>
							</div>
							<div id="navbar" class="navbar-collapse collapse">
								<?php get_template_part("templates/navigation","menu"); ?>	
							</div>
						</nav>
					</div>
					<div id="slidepanel" class="col-md-6 slidepanel">
						<div class="col-md-6 col-sm-6 col-xs-6 address">
							<p>
								<a href="tel:<?php echo esc_attr(lacero_options("opt_phone_one") ); ?>" title="Phone"><?php echo esc_html( lacero_options("opt_phone_one") ); ?></a>
								<a href="tel:<?php echo esc_attr(lacero_options("opt_phone_two") ); ?>" title="Phone"><?php echo esc_html(lacero_options("opt_phone_two") ); ?></a>
							</p>
							<?php echo lacero_content( '<p>','</p>', esc_html( lacero_options("opt_header_desc") ) ); ?>
						</div>
						<div class="col-md-6 col-sm-6 col-xs-6 social">
							<ul>
								<?php 
									echo lacero_content( '<li><a target="_blank" href="','"><i class="fa fa-facebook"></i></a></li>',esc_url( lacero_options("opt_facebook") ) );
									echo lacero_content( '<li><a target="_blank" href="','"><i class="fa fa-twitter"></i></a></li>',esc_url( lacero_options("opt_twitter") ) );
									echo lacero_content( '<li><a target="_blank" href="','"><i class="fa fa-google-plus"></i></a></li>',esc_url( lacero_options("opt_googleplus") ) );
									echo lacero_content( '<li><a target="_blank" href="','"><i class="fa fa-linkedin"></i></a></li>',esc_url( lacero_options("opt_linkedin") ) );
								?>
							</ul>
							<div class="search-box">
								<?php get_search_form(); ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</header>
		<?php get_template_part("templates/page","banner"); ?>