<?php
require_once( trailingslashit( get_template_directory() ) . 'include/inc.php' );
require_once( trailingslashit( get_template_directory() ) . 'admin/inc.php' );

/* ************************************************************************ */

if( !function_exists('lacero_options') ) :

	function lacero_options( $option, $arr = null ) {

		global $lacero_option;

		if( $arr ) {

			if( isset( $lacero_option[$option][$arr] ) ) {
				return $lacero_option[$option][$arr];
			}
		}
		else {
			if( isset( $lacero_option[$option] ) ) {
				return $lacero_option[$option];
			}
		}
	}
endif;

/* ************************************************************************ */

/**
 * Set up the content width value based on the theme's design.
 *
 * @see lacero_content_width()
 *
 * @since Lacero 1.0
 */
if ( ! isset( $content_width ) ) { $content_width = 474; }

/**
 * Adjust content_width value for image attachment template.
 *
 * @since Lacero 1.0
 */
if( !function_exists('lacero_content_width') ) :
	function lacero_content_width() {
		if ( is_attachment() && wp_attachment_is_image() ) { $GLOBALS['content_width'] = 810; }
	}
	add_action( 'template_redirect', 'lacero_content_width' );
endif;

/* ************************************************************************ */

/**
 * Theme setup.
 *
 * Set up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support post thumbnails.
 *
 * @since Lacero 1.0
 */
if( !function_exists('lacero_theme_setup') ) :

	function lacero_theme_setup() {

		/* load theme languages */
		load_theme_textdomain( "lacero", get_template_directory() . '/languages' );
	
		/* Image Sizes */
		set_post_thumbnail_size( 768, 338, true ); /* Default Featured Image */

		add_image_size( 'lacero-768-338', 768, 338, true ); /* Single Blog Post  Gallery */
		add_image_size( 'lacero-1140-360', 1140, 360, true ); /* Single Events */

		// This theme uses wp_nav_menu() in two locations.
		register_nav_menus( array(
			'lacero_primary_nav'   => esc_html__( 'Primary menu', "lacero" ),
			'lacero_secondary_nav'   => esc_html__( 'Footer menu', "lacero" ),
		) );

		add_theme_support( 'automatic-feed-links' );

		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );

		add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption' ) );

		/*
		 * Enable support for Post Formats.
		 *
		 * See: https://codex.wordpress.org/Post_Formats
		 */
		add_theme_support( 'post-formats', array( 'video', 'gallery', 'audio' ) );
	}
	add_action( 'after_setup_theme', 'lacero_theme_setup' );
endif;


/* Google Font */
function lacero_fonts_url() {

    $fonts_url = '';
 
    $work_sans = _x( 'on', 'Work Sans: on or off', "lacero" );
    $oswald = _x( 'on', 'Oswald: on or off', "lacero" );
    $alice = _x( 'on', 'Alice: on or off', "lacero" );
    $roboto = _x( 'on', 'Roboto: on or off', "lacero" );
    $martel_sans = _x( 'on', 'Martel Sans: on or off', "lacero" );
 
    if ( 'off' !== $work_sans || 'off' !== $oswald  || 'off' !== $alice  || 'off' !== $roboto  || 'off' !== $martel_sans ) {

        $font_families = array();
 
        if ( 'off' !== $work_sans ) {
            $font_families[] = 'Work Sans:400,200,100,300,500,600,700,800,900';
        }
 
        if ( 'off' !== $oswald ) {
            $font_families[] = 'Oswald:300,400,700';
        }
 
        if ( 'off' !== $alice ) {
            $font_families[] = 'Alice';
        }
		
		if ( 'off' !== $roboto ) {
            $font_families[] = 'Roboto:400,100,100italic,300,300italic,400italic,500,500italic,700,700italic,900,900italic';
        }
		
		 if ( 'off' !== $martel_sans ) {
            $font_families[] = 'Martel Sans:400,200,300,600,700,800,900';
        }
 
        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            'subset' => urlencode( 'latin,latin-ext' ),
        );
 
        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }
 
    return esc_url_raw( $fonts_url );
}

/* ************************************************************************ */

/**
 * Enqueue scripts and styles for the front end.
 *
 * @since Lacero 1.0
 */
if( !function_exists('lacero_enqueue_scripts') ) :

	function lacero_enqueue_scripts() {
	
		// load the Internet Explorer specific stylesheet.
		wp_enqueue_style( 'ie-css', get_template_directory_uri() . '/css/ie.css');
		wp_style_add_data( 'ie-css', 'conditional', 'lt IE 9' );
		
		// Load the html5 shiv.
		wp_enqueue_script( 'respond-min', get_template_directory_uri() . '/js/html5/respond.min.js' );
		wp_script_add_data( 'respond-min', 'conditional', 'lt IE 9' );

		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
		
		wp_enqueue_style( 'lacero-fonts', lacero_fonts_url(), array(), null );
		
		/* Font Icons */
		wp_enqueue_style( 'dashicons' );
		wp_enqueue_style( 'lacero-lib', get_template_directory_uri() . '/libraries/lib.css');
		wp_enqueue_style( 'lacero-navmenu', get_template_directory_uri() . '/css/navigation-menu.css');

		/* Custom Stylesheet */
		wp_enqueue_style( 'lacero-stylesheet', get_template_directory_uri() . '/style.css' );
		wp_add_inline_style( 'lacero-stylesheet', get_theme_mod('custom_css') );
		wp_enqueue_style( 'lacero-shortcodes', get_template_directory_uri() . '/css/shortcodes.css');

		/* Functions JS */		
		wp_enqueue_script( 'lacero-lib', get_template_directory_uri() . '/libraries/lib.js', array( 'jquery' ),  null, true );
		wp_enqueue_script( 'lacero-functions', get_template_directory_uri() . '/js/functions.js', array( 'jquery' ),  null, true );
	}
	add_action( 'wp_enqueue_scripts', 'lacero_enqueue_scripts' );
endif;

/* ************************************************************************ */

/**
 * Extend the default WordPress body classes.
 *
 * @since Nextgen 1.0
 *
 * @param array $classes A list of existing body class values.
 * @return array The filtered body class list.
 */
if( !function_exists('lacero_body_classes') ) :

	function lacero_body_classes( $classes ) {

		if ( is_singular() && ! is_front_page() ) {
			$classes[] = 'singular';
		}

		if( is_front_page() && !is_home() ) {
			$classes[] = 'front-page';
		}

		return $classes;
	}
	add_filter( 'body_class', 'lacero_body_classes' );
endif;

/**
 * Extend the default WordPress post classes.
 *
 * Adds a post class to denote:
 * Non-password protected page with a post thumbnail.
 *
 * @since Lacero 1.0
 *
 * @param array $classes A list of existing post class values.
 * @return array The filtered post class list.
 */
if( !function_exists('lacero_post_classes') ) :
	function lacero_post_classes( $classes ) {
		if ( ! is_attachment() && has_post_thumbnail() ) { $classes[] = 'has-post-thumbnail'; }
		return $classes;
	}
	add_filter( 'post_class', 'lacero_post_classes' );
endif;

/**
 * Add a `screen-reader-text` class to the search form's submit button.
 *
 * @since Lacero 1.0
 *
 * @param string $html Search form HTML.
 * @return string Modified search form HTML.
 */
function lacero_search_form_modify( $html ) {
	$html = '<form method="get" id="searchform" class="searchform" action="' . home_url( '/' ) . '" >
	<div class="input-group">
	<input type="text" name="s" id="s" placeholder="'.esc_html("Search","lacero").'" class="form-control" required>
	<span class="input-group-btn">
		<button class="btn btn-default" type="submit"><i class="fa fa-search"></i></button>
	</span>
	</div><!-- /input-group -->
	</form>';
	return $html;
}
add_filter( 'get_search_form', 'lacero_search_form_modify' );