<?php
/**
 * The template for displaying the footer
 *
 * Contains footer content and the closing of the #main and #page div elements.
 *
 * @package WordPress
 * @subpackage Lacero
 * @since Lacero 1.0
 */
?>	

		<?php
		if( get_post_meta( get_the_ID(), 'lacero_cf_page_newslatter', true ) != "off" ) {
			?>
			<div class="newsletter-section container-fluid no-padding">
				<div class="newsletter-shape">
					<svg width="100%" height="100%">
						<clipPath id="newsletter" clipPathUnits="objectBoundingBox">
							<polygon points="0 0, 0 1, 1 1, 0.85 0"></polygon>
						</clipPath>
					</svg>
				</div>
				<?php
				if( function_exists('lacero_mcform') && lacero_options("opt_mailchimp") != "" ) {
					?>
					<div class="container">
						<div class="row">
							<div class="col-md-4 col-sm-4 newsletter-title">
								<h3><span><?php echo esc_attr( lacero_options("opt_newslatter_txt") ); ?></span> <?php echo esc_attr( lacero_options("opt_newslatter_stxt") ); ?></h3>
							</div>
							<div class="col-md-8 col-sm-8 col-xs-12 newsletter-box">
								<?php echo lacero_mcform(); ?>
							</div>
						</div>
					</div>
					<?php
				} ?>
			</div>
			<?php
		}
		?>

		<!-- Footer Main -->
		<footer class="footer-main container-fluid no-padding">
			<div class="container">
				<div class="row">
					
					<div class="col-md-12 col-sm-12 col-xs-12 ftr-logo">
						<?php
						if( lacero_options("opt_site_logo_footer","url") != "" ) {
							?>
							<a class="image-logo" href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url( lacero_options("opt_site_logo_footer","url") ); ?>" alt=""/></a>
							<?php
						} ?>
						<?php dynamic_sidebar('sidebar-3'); ?>
					</div>
					<div class="ftr-widget col-md-12 col-sm-12 col-xs-12 no-padding">
						<?php
						if ( is_active_sidebar( 'sidebar-4' ) ) { 
							?>
							<div class="col-md-3 col-sm-6 col-xs-12 widget widget-get-in-touch">
								<?php dynamic_sidebar('sidebar-4'); ?>
							</div>
							<?php
						}
						
						if ( is_active_sidebar( 'sidebar-5' ) ) { 
							?>
							<div class="col-md-3 col-sm-6 col-xs-12 widget widget-event">
								<?php dynamic_sidebar('sidebar-5'); ?>
							</div>
							<?php
						}
						
						if ( is_active_sidebar( 'sidebar-6' ) ) { 
							?>
							<div class="col-md-3 col-sm-6 col-xs-12 widget widget-twitter">
								<?php dynamic_sidebar('sidebar-6'); ?>
							</div>
							<?php
						}
						if ( is_active_sidebar( 'sidebar-7' ) ) { 
							?>
							<div class="col-md-3 col-sm-6 col-xs-12 widget widget-gallery">
								<?php dynamic_sidebar('sidebar-7'); ?>
							</div>
						<?php
						}
						?>
					</div>	
					<div class="footer-bottom col-md-12 col-sm-12 col-xs-12 no-padding">
						<div class="col-md-7 col-sm-12 col-xs-12 no-padding">				
							<?php
							if( has_nav_menu('lacero_secondary_nav') ) :
								wp_nav_menu( array(
									'theme_location' => 'lacero_secondary_nav',
									'container' => false,
									'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
									'depth' => 10,
									'menu_class' => 'footer-menu',
									'depth' => 10 ,
									'walker' => new lacero_nav_walker
								));
							else :
								echo '<ul class="footer-menu">'
									.wp_list_pages(array(
									'echo'            => 0,
									'walker'          => new lacero_wp_page_walker,
									'title_li'        => ''
								)).'</ul>';
							endif;
							?>
						</div>
						<div class="col-md-5 col-sm-12 col-xs-12">
							<?php echo wpautop( lacero_options('opt_footer_copyright') ); ?>
						</div>
					</div>
				</div>
			</div>
		</footer>
	</div>
	<?php wp_footer(); ?>
</body>
</html>