<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 * @package WordPress
 * @subpackage Lacero
 * @since Lacero 1.0
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( ); ?>>
	
	<?php if ( is_sticky() && is_home() && ! is_paged() ) : ?>
		<span class="sticky-post"><?php esc_html_e( 'Featured', "lacero" ); ?></span>
	<?php endif; 
	
	$post_format = get_post_format();
	if( $post_format == "gallery" && count( get_post_meta( get_the_ID(), 'lacero_cf_post_gallery', 1 ) ) > 0 && is_array( get_post_meta( get_the_ID(), 'lacero_cf_post_gallery', 1 ) ) ) {
		?>
		<div class="entry-cover">
			<div id="blog-carousel-<?php echo the_ID(); ?>" class="carousel slide" data-ride="carousel">
				<div class="carousel-inner" role="listbox">
					<?php
					$active=1;
					foreach ( (array) get_post_meta( get_the_ID(), 'lacero_cf_post_gallery', 1 ) as $attachment_id => $attachment_url ) {
						?>
						<div class="item<?php if( $active == 1 ) { echo ' active'; } ?>">
							<?php echo wp_get_attachment_image( $attachment_id, 'lacero-760-338' ); ?>
						</div>
						<?php
						$active++;
					} ?>
				</div>
				<a title="Previous" class="left carousel-control" href="#blog-carousel-<?php echo the_ID(); ?>" role="button" data-slide="prev">
					<span class="fa fa-chevron-left" aria-hidden="true"></span>
				</a>
				<a title="Next" class="right carousel-control" href="#blog-carousel-<?php echo the_ID(); ?>" role="button" data-slide="next">
					<span class="fa fa-chevron-right" aria-hidden="true"></span>
				</a>
			</div>
		</div>
		<?php
	}
	if( is_single() ) :
		?>
		<div class="blog-single">
		<?php
			/* Post Format : Video */
		if( $post_format == "video" ) {

			if( get_post_meta( get_the_ID(), 'lacero_cf_post_video_source', 1 ) == "video_link" && get_post_meta( get_the_ID(), 'lacero_cf_post_video_link', 1 ) != "" ) {
				echo wp_oembed_get( esc_url( get_post_meta( get_the_ID(), 'lacero_cf_post_video_link', true ) ) );
			}
			elseif( get_post_meta( get_the_ID(), 'lacero_cf_post_video_source', 1 ) == "video_embed_code" && get_post_meta( get_the_ID(), 'lacero_cf_post_video_embed', 1 ) != "" ) {
				echo get_post_meta( get_the_ID(), 'lacero_cf_post_video_embed', 1 );
			}
			elseif( get_post_meta( get_the_ID(), 'lacero_cf_post_video_source', 1 ) == "video_upload_local" && get_post_meta( get_the_ID(), 'lacero_cf_post_video_local', 1 ) != "" ) {
				?>
				<video controls>
					<source src="<?php echo esc_url( get_post_meta( get_the_ID(), 'lacero_cf_post_video_local', 1 ) ); ?>" type="video/mp4">
					<?php esc_html_e("Your browser does not support the video tag.","lacero"); ?>
				</video> 
				<?php			
			}
		}

		/* Post Format : Audio */
		if( $post_format == "audio" ) {

			if( get_post_meta( get_the_ID(), 'lacero_cf_post_audio_source', 1 ) == "soundcloud_link" && get_post_meta( get_the_ID(), 'lacero_cf_post_soundcloud_url', 1 ) != "" ) {
				?>
				<iframe src="<?php echo esc_url( get_post_meta( get_the_ID(), 'lacero_cf_post_soundcloud_url', 1 ) ); ?>"></iframe>
				<?php
			}
			elseif( get_post_meta( get_the_ID(), 'lacero_cf_post_audio_source', 1 ) == "audio_upload_local" && get_post_meta( get_the_ID(), 'lacero_cf_post_audio_local', 1 ) != "" ) {
				?>
				<audio controls>
					<source src="<?php echo esc_url( get_post_meta( get_the_ID(), 'lacero_cf_post_audio_local', 1 ) ); ?>" type="audio/mpeg">
					<?php esc_html_e("Your browser does not support the audio element.","lacero"); ?>
				</audio>
				<?php
			}
		}
	
		if( has_post_thumbnail() && ( $post_format != "audio" && $post_format != "video" && $post_format != "gallery" ) ) {
			?>
			<div class="entry-cover">
				<?php the_post_thumbnail(); ?>
				<div class="entry-date">
					<span><?php echo get_the_date( 'd', get_the_ID() ); ?></span>
					<span><?php echo get_the_date( 'M', get_the_ID() ); ?></span>
				</div>
			</div>
			<?php
		}
		else {
			// Do nothing...
		}
		the_title( '<h3 class="entry-title">', '</h3>' ); 
		?>
		
		<div class="entry-meta social-icon-share"><span><i class="fa fa-calendar"></i><?php esc_html_e('Date: ', 'lacero'); ?><?php echo get_the_date( get_option('date_format'), get_the_ID() ); ?></span>
			<span><?php if( function_exists('lacero_get_simple_likes_button') ) { echo lacero_get_simple_likes_button( get_the_ID() ); } ?> </span>
			<span><a href="<?php comments_link(); ?>"><i class="fa fa-comment-o"></i><?php comments_number(__( '0', "lacero" ), __( '1', "lacero" ),__( '(%) Comments', "lacero" )); ?></a></span>
			<span><i class="fa fa-share-alt"></i><?php esc_html_e('Share It',"lacero"); ?></span>
			<ul>	
				<li><a href="javascript: void(0)" data-action="facebook" data-title="<?php the_title(); ?>" data-url="<?php echo esc_url(the_permalink()); ?>"><i class="fa fa-facebook"></i></a></li>
				<li><a href="javascript: void(0)" data-action="google-plus" data-url="<?php echo esc_url(the_permalink()); ?>"><i class="fa fa-google-plus"></i></a></li>
				<li><a href="javascript: void(0)" data-action="twitter" data-title="<?php the_title(); ?>" data-url="<?php echo esc_url(the_permalink()); ?>"><i class="fa fa-twitter"></i></a></li>
				<li><a href="javascript: void(0)" data-action="dribbble" data-title="<?php the_title(); ?>" data-url="<?php echo esc_url(the_permalink()); ?>"><i class="fa fa-dribbble"></i></a></li>
			</ul>
		</div>
		<div class="entry-content">
			<div class="entry-content-inner">
			<?php
				if( is_single() ) {
					/* translators: %s: Name of current post */
					the_content( sprintf(
						__( 'Continue reading %s', "lacero" ),
						the_title( '<span class="screen-reader-text">', '</span>', false )
					) );

					wp_link_pages( array(
						'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', "lacero" ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . __( 'Page', "lacero" ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					) );
				}
				else {
					the_excerpt();
				}
			?>
			</div>
			<div class="tags">
				<span>
					<i>
						<img src="<?php echo esc_url( LACERO_IMGURI ); ?>/icon/singlepost-ic-1.png" alt="singlepost-ic" />
					</i>
					<span><?php esc_html_e("By ","lacero"); ?></span> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_the_author(); ?></a>
				</span>
				<?php
				if( has_tag() ) {
					?>
					<span>
						<i>
							<img src="<?php echo esc_url( LACERO_IMGURI ); ?>/icon/singlepost-ic-2.png" alt="singlepost-ic" />
						</i>
				
						<span class="entry-tags">
							<?php the_tags(); ?>
						</span>
					</span>
					<?php
				}
				?>				
				<span><i class="fa fa-link"></i><?php esc_html_e( 'Category:',"lacero" ); ?>
				<?php the_category( ' , ' ); ?></span>
			</div>
		</div>
	</div>
	<?php
	else:
		?>
		<div class="blog-post-inner">
		<?php
			// Get post format
			$post_format = get_post_format();
			
			/* Post Format : Video */
			if( $post_format == "video" ) {

				if( get_post_meta( get_the_ID(), 'lacero_cf_post_video_source', 1 ) == "video_link" && get_post_meta( get_the_ID(), 'lacero_cf_post_video_link', 1 ) != "" ) {
					echo wp_oembed_get( esc_url( get_post_meta( get_the_ID(), 'lacero_cf_post_video_link', true ) ) );
				}
				elseif( get_post_meta( get_the_ID(), 'lacero_cf_post_video_source', 1 ) == "video_embed_code" && get_post_meta( get_the_ID(), 'lacero_cf_post_video_embed', 1 ) != "" ) {
					echo get_post_meta( get_the_ID(), 'lacero_cf_post_video_embed', 1 );
				}
				elseif( get_post_meta( get_the_ID(), 'lacero_cf_post_video_source', 1 ) == "video_upload_local" && get_post_meta( get_the_ID(), 'lacero_cf_post_video_local', 1 ) != "" ) {
					?>
					<video controls>
						<source src="<?php echo esc_url( get_post_meta( get_the_ID(), 'lacero_cf_post_video_local', 1 ) ); ?>" type="video/mp4">
						<?php esc_html_e("Your browser does not support the video tag.","lacero"); ?>
					</video> 
					<?php			
				}
			}

			/* Post Format : Audio */
			if( $post_format == "audio" ) {

				if( get_post_meta( get_the_ID(), 'lacero_cf_post_audio_source', 1 ) == "soundcloud_link" && get_post_meta( get_the_ID(), 'lacero_cf_post_soundcloud_url', 1 ) != "" ) {
					?>
					<iframe src="<?php echo esc_url( get_post_meta( get_the_ID(), 'lacero_cf_post_soundcloud_url', 1 ) ); ?>"></iframe>
					<?php
				}
				elseif( get_post_meta( get_the_ID(), 'lacero_cf_post_audio_source', 1 ) == "audio_upload_local" && get_post_meta( get_the_ID(), 'lacero_cf_post_audio_local', 1 ) != "" ) {
					?>
					<audio controls>
						<source src="<?php echo esc_url( get_post_meta( get_the_ID(), 'lacero_cf_post_audio_local', 1 ) ); ?>" type="audio/mpeg">
						<?php esc_html_e("Your browser does not support the audio element.","lacero"); ?>
					</audio>
					<?php
				}
			}

			if( has_post_thumbnail() && ( $post_format != "audio" && $post_format != "video" && $post_format != "gallery" ) ) {
				?>
				<div class="entry-cover"> 
					<a href="<?php echo esc_url( get_permalink() ); ?>">
						<?php the_post_thumbnail(); ?>
					</a>
					<div class="entry-date">
						<span><?php echo get_the_date( 'd', get_the_ID() ); ?></span>
						<span><?php echo get_the_date( 'M', get_the_ID() ); ?></span>
					</div>
				</div>
				<?php
			}
			?>
			<h3 class="entry-title">
				<a href="<?php echo the_permalink(); ?>">
					<?php the_title(); ?>
				</a>
			</h3>
			<div class="entry-meta social-icon-share"><span><a href="<?php the_permalink(); ?>"><i class="fa fa-calendar"></i><?php esc_html_e('Date: ', 'lacero'); ?><?php echo get_the_date( get_option('date_format'), get_the_ID() ); ?></a></span>
				<span><?php if( function_exists('lacero_get_simple_likes_button') ) { echo lacero_get_simple_likes_button( get_the_ID() ); } ?> </span>
				<span><a href="<?php comments_link(); ?>"><i class="fa fa-comment-o"></i><?php comments_number(__( '0', "lacero" ), __( '1', "lacero" ),__( '(%) Comments', "lacero" )); ?></a></span>
				<span><i class="fa fa-share-alt"></i><?php esc_html_e('Share It',"lacero"); ?></span>
				<ul>	
					<li><a href="javascript: void(0)" data-action="facebook" data-title="<?php the_title(); ?>" data-url="<?php echo esc_url(the_permalink()); ?>"><i class="fa fa-facebook"></i></a></li>
					<li><a href="javascript: void(0)" data-action="google-plus" data-url="<?php echo esc_url(the_permalink()); ?>"><i class="fa fa-google-plus"></i></a></li>
					<li><a href="javascript: void(0)" data-action="twitter" data-title="<?php the_title(); ?>" data-url="<?php echo esc_url(the_permalink()); ?>"><i class="fa fa-twitter"></i></a></li>
					<li><a href="javascript: void(0)" data-action="dribbble" data-title="<?php the_title(); ?>" data-url="<?php echo esc_url(the_permalink()); ?>"><i class="fa fa-dribbble"></i></a></li>
				</ul>
			</div>
			<div class="entry-content">
				<?php the_excerpt(); ?>
			</div>
			<a class="single-read-more" href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e('Read More',"lacero"); ?></a>
		</div>
		<?php
	endif;
	?>
</article>
<div class="clearfix"></div>