<?php
/**
 * The template used for displaying page content
 *
 * @package WordPress
 * @subpackage Lacero
 * @since Lacero 1.0
 */

if( !is_single() ) {
	?>
	<div class="archive-eventlist"> 	
	<?php
}
else {
	?>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php
}
	if( is_single() ) {
		?>
		<div class="content"> 
			<div class="event-pages event-detail">
				<div class="events">
					<?php the_post_thumbnail('lacero-1140-360'); ?>
					<div class="col-xs-12 no-padding">
						<?php the_title("<h5>","</h5>"); ?>
						<div class="date-place">
							<?php echo lacero_content('<span><i class="fa fa-clock-o"></i>','</span>',esc_attr( get_post_meta( get_the_ID(), 'lacero_cf_event_datetime', true ) ) ); ?>
							<?php echo lacero_content('<span><i class="fa fa-map-marker"></i>','</span>',esc_attr( get_post_meta( get_the_ID(), 'lacero_cf_event_location', true ) ) ); ?>
						</div>
						<div class="event-contact-info">
							<?php echo lacero_content('<span><i class="fa fa-envelope"></i>','</span>',esc_attr( get_post_meta( get_the_ID(), 'lacero_cf_event_email', true ) ) ); ?>
							<?php echo lacero_content('<span><i class="fa fa-phone"></i>','</span>',esc_attr( get_post_meta( get_the_ID(), 'lacero_cf_event_phone', true ) ) ); ?>
						</div>
					  <div class="entry-content">
							<?php
							/* translators: %s: Name of current post */
							the_content( sprintf(
								__( 'Continue reading %s', "lacero" ),
								the_title( '<span class="screen-reader-text">', '</span>', false )
							) );

							wp_link_pages( array(
								'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', "lacero" ) . '</span>',
								'after'       => '</div>',
								'link_before' => '<span>',
								'link_after'  => '</span>',
								'pagelink'    => '<span class="screen-reader-text">' . __( 'Page', "lacero" ) . ' </span>%',
								'separator'   => '<span class="screen-reader-text">, </span>',
							) );
							?>
						</div>
						<?php
						if( get_post_meta( get_the_ID(), 'lacero_cf_map_longitute', true ) != "" && get_post_meta( get_the_ID(), 'lacero_cf_map_longitute', true ) != "" ) {
							?>
							<div class="map">
								<div class="map-canvas" id="map-canvas-contact" data-lat="<?php echo esc_html( get_post_meta( get_the_ID(), 'lacero_cf_map_latitude', true ) ); ?>" data-lng="<?php echo esc_html( get_post_meta( get_the_ID(), 'lacero_cf_map_longitute', true ) ); ?>" data-marker="<?php echo esc_url( LACERO_IMGURI ).'/marker.png'; ?>" data-string="<?php echo esc_html( get_post_meta( get_the_ID(), 'lacero_cf_event_address', true ) ); ?>" data-zoom="12"></div>
							</div>
							<?php
							}
						?>
					</div>
				</div>
			</div>	
		</div>
		<?php
	}
	else {
		?>
		<div class="col-md-4 col-sm-6">
			<div class="courses-box animated rollIn">
				<div class="courses-img-box">
					<?php the_post_thumbnail('lacero-370-360'); ?>
					<div class="courses-box-hover">
						<h3><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h3>
						<?php echo lacero_content('<div class="date-place"><span><i class="fa fa-clock-o"></i>','</span></div>', esc_attr( get_post_meta( get_the_ID(), 'lacero_cf_event_datetime', true ) ) ); ?>
						<p><?php echo lacero_excerpt(10); ?></p>
						<a class="btn" href="<?php the_permalink(); ?>"><?php esc_html_e("View Event", "lacero"); ?></a>
					</div>
				</div>
				<span class="box-toggle"></span>
			</div>
		</div>
		<?php
	}
if( !is_single() ) {
	?>
	</div> 	
	<?php
}
else {
	?>
	</article>
	<?php
}