<?php
/**
 * The template used for displaying page content
 *
 * @package WordPress
 * @subpackage Lacero
 * @since Lacero 1.0
 */

if( !is_single() ) {
	?>
	<div class="archive-courses"> 	
	<?php
}
else {
	?>
<article id="post-<?php get_the_ID(); ?>" <?php post_class(); ?>>
	<?php
	}
	if( is_single() ) {
		?>
		<div class="content"> 
			<div class="course-details">
				<div class="container">
					<div class="row"> 
						<div class="courses">							
							<div class="col-md-12">
								<?php
								if( has_post_thumbnail() ) {
									?>
									<div class="post_thumb">
										<?php the_post_thumbnail( 'lacero-1140-360' ); ?>
									</div>
									<?php
								}
								// the_title("<h3>","</h3>");
								?>
								<div class="entry-content">
									<?php
									/* translators: %s: Name of current post */
									the_content( sprintf(
										__( 'Continue reading %s', "lacero" ),
										the_title( '<span class="screen-reader-text">', '</span>', false )
									) );

									wp_link_pages( array(
										'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', "lacero" ) . '</span>',
										'after'       => '</div>',
										'link_before' => '<span>',
										'link_after'  => '</span>',
										'pagelink'    => '<span class="screen-reader-text">' . __( 'Page', "lacero" ) . ' </span>%',
										'separator'   => '<span class="screen-reader-text">, </span>',
									) );
									?>
								</div>
								<?php
								if( get_post_meta( get_the_ID(), 'lacero_cf_courses_duration', true  ) != "" || get_post_meta( get_the_ID(), 'lacero_cf_courses_degree', true ) != "" ) { 
									?>
									<p>
										
										<?php 
											if( get_post_meta( get_the_ID(), 'lacero_cf_courses_duration', true  ) != "" ) { 
												?>
												<span><i class="fa fa-calendar"></i><?php esc_html_e('Course duration : ',"lacero"); ?><?php echo esc_html( get_post_meta( get_the_ID(), 'lacero_cf_courses_duration', true ) ); ?></span>
												<?php
											}
											if( get_post_meta( get_the_ID(), 'lacero_cf_courses_degree', true  ) != "" ) { 
												?>
												<span><i class="fa fa-graduation-cap"></i><?php esc_html_e('Degree Level : ',"lacero"); ?><?php echo esc_html( get_post_meta( get_the_ID(), 'lacero_cf_courses_degree', true ) ); ?></span>
												<?php
											}
										?>
										
									</p>
									<?php
								}?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
		}
	else {
		?>
		<div class="col-md-4 col-sm-6">
			<div class="courses-box">
				<div class="courses-img-box">
					<?php the_post_thumbnail( 'lacero-370-360' ); ?>
					<div class="courses-box-hover">
						<h3><?php the_title(); ?></h3>
						<p><?php echo lacero_length( esc_html( get_the_content( ) ),10 ); ?></p>
						<?php
						if( function_exists('lacero_regform') && lacero_options("registrationform") != "" ) {
							?>
							<button type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#myModal-<?php get_the_ID(); ?>">
							  <?php esc_html_e('Apply Now',"lacero"); ?>
							</button>
							<?php
						} ?>
						<a href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e('Read More',"lacero"); ?></a>
					</div>
				</div>
				<span class="box-toggle"></span>
			</div>
			<?php
			if( function_exists('lacero_regform') && lacero_options("registrationform") != "" ) {
				?>
				<!-- Modal -->
				<div class="modal fade" id="myModal-<?php get_the_ID(); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel-<?php get_the_ID(); ?>">
					<div class="modal-dialog" role="document">
						<div class="modal-content">
							<div class="modal-header">
								<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
								<h4 class="modal-title" id="myModalLabel-<?php get_the_ID(); ?>"><?php esc_html_e('Registration Form',"lacero"); ?></h4>
							</div>
							 <div class="modal-body">
								<?php echo lacero_regform(); ?>
							</div>
					  
						</div>
					</div>
				</div>
				<?php
			} ?>
		</div>
		<?php
		}
	if( !is_single() ) {
		?>
	</div> 	
	<?php
	}
	else {
	?>
</article>
<?php
}
