<?php
/**
 * The template for displaying archive pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Elead
 * @since Elead 0.1
 */

get_header(); ?>
	<div class="wrapper page-section">
		<div id="primary" class="content-area">
			<main id="main" class="site-main" role="main">
				<div id="archive-blog-wrapper" class="archive-blog-wrapper clear col-3">
				<?php
				if ( have_posts() ) : ?>
					<?php
					/* Start the Loop */
					while ( have_posts() ) : the_post();

						/*
						 * Include the Post-Format-specific template for the content.
						 * If you want to override this in a child theme, then include a file
						 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
						 */
						get_template_part( 'template-parts/content', get_post_format() );

					endwhile;

				else :

					get_template_part( 'template-parts/content', 'none' );

				endif; ?>
				</div><!-- .archive-blog-wrapper -->
				<?php
				
				/**
				* Hook - elead_action_pagination.
				*
				* @hooked elead_pagination
				*/
				do_action( 'elead_action_pagination' ); 
				?>

			</main><!-- #main -->
		</div><!-- #primary -->
	</div><!-- .wrapper -->
<?php
get_footer();
