package com.library.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;


import com.library.model.Book;
import com.library.util.DbUtil;

public class BookDaoImplementation implements BookDao 
{
	private Connection connect;
	
	public BookDaoImplementation() 
	{
		connect = DbUtil.getConnection();
	}

	@Override
	public void addBook(Book book) 
	{
		try
		{
			String query = "insert into book (title, author, isbn, stock) values (?,?,?,?)";
			PreparedStatement preparedStatement = connect.prepareStatement(query);
			preparedStatement.setString(1, book.getTitle());
			preparedStatement.setString(2, book.getAuthor());
			preparedStatement.setString(3, book.getIsbn());
			preparedStatement.setInt(4, book.getStock());
			preparedStatement.executeUpdate();
			preparedStatement.close();
		} catch (SQLException e)
		{
			e.printStackTrace();
		}
	}

	@Override
	public void deleteBook(int bookId) 
	{
		try
		{
			String query = "delete from book where bookId=?";
			PreparedStatement preparedStatement = connect.prepareStatement(query);
			preparedStatement.setInt(1, bookId);
			preparedStatement.executeUpdate();
			preparedStatement.close();
		} catch (SQLException e)
		{
			e.printStackTrace();
		}
	}

	@Override
	public void updateBook(Book book) 
	{
		try
		{
			String query = "update book set title=?, author=?, isbn=?, stock=? where isBook=?";
			PreparedStatement preparedStatement = connect.prepareStatement(query);
			preparedStatement.setString(1, book.getTitle());
			preparedStatement.setString(2, book.getAuthor());
			preparedStatement.setString(3, book.getIsbn());
			preparedStatement.setInt(4, book.getStock());
			preparedStatement.setInt(5, book.getBookId());
			preparedStatement.executeUpdate();
			preparedStatement.close();
		} catch (SQLException e)
		{
			e.printStackTrace();
		}
	}

	@Override
	public List<Book> getAllBooks() 
	{
		List<Book> books = new ArrayList<Book>();
		try {
            Statement statement = connect.createStatement();
            ResultSet resultSet = statement.executeQuery( "select * from book" );
            while( resultSet.next() ) {
                Book book = new Book();
                book.setBookId( resultSet.getInt( "bookId" ) );
                book.setTitle( resultSet.getString( "title" ) );
                book.setAuthor( resultSet.getString( "author" ) );
                book.setIsbn( resultSet.getString( "isbn" ) );
                book.setStock( resultSet.getInt( "stock" ) );
                books.add(book);
            }
            resultSet.close();
            statement.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return books;
	}

	@Override
	public Book getBookById(int bookId) 
	{
		Book book = new Book();
        try 
        {
            String query = "select * from book where bookId=?";
            PreparedStatement preparedStatement = connect.prepareStatement(query);
            preparedStatement.setInt(1, bookId);
            ResultSet resultSet = preparedStatement.executeQuery();
            while(resultSet.next()) 
            {
                book.setBookId(resultSet.getInt("bookId"));
                book.setTitle(resultSet.getString("title"));
                book.setAuthor(resultSet.getString("author"));
                book.setIsbn(resultSet.getString("isbn"));
                book.setStock( resultSet.getInt("stock"));
            }
            resultSet.close();
            preparedStatement.close();
        } catch (SQLException e) 
        {
            e.printStackTrace();
        }
        return book;
    }
		
}
